# バッチ設計書 13-npm run test-e2e-webgpu

## 概要

本ドキュメントは、three.jsプロジェクトにおけるWebGPU関連examplesのE2Eテストバッチ `npm run test-e2e-webgpu` の設計仕様を定義する。

### 本バッチの処理概要

Puppeteerを使用してWebGPU関連（`webgpu_`プレフィックス）のexamplesのみを対象としたE2Eテストを実行するバッチである。test-e2eバッチのサブセットとして、WebGPUレンダラーを使用するサンプルに特化したビジュアルリグレッションテストを行う。

**業務上の目的・背景**：three.jsはWebGLに加えてWebGPUレンダラーもサポートしている。WebGPU関連のexamplesはWebGL版とは異なる技術スタックを使用するため、専用のテストが必要となる。このバッチにより、WebGPU機能の開発時にWebGPU関連のexamplesのみを効率的にテストできる。全examplesを対象としたtest-e2eよりも高速に実行可能。

**バッチの実行タイミング**：開発者によるローカル環境での手動実行が主な用途。WebGPU関連の変更を行った際に限定的なテストを実行する場合に使用。

**主要な処理内容**：
1. ローカルHTTPサーバーの起動（ポート1234）
2. Puppeteerによるヘッドレスブラウザの起動（SwiftShader使用）
3. `webgpu_`プレフィックスを持つexamplesのフィルタリング
4. 各exampleのページ読み込みとレンダリング待機
5. スクリーンショット撮影と参照画像との比較
6. 差分がしきい値を超えた場合のエラー報告

**前後の処理との関連**：`npm run build-module`によるビルド完了後に実行可能。test-e2eの--webgpuオプション付き実行と同等。

**影響範囲**：webgpu_プレフィックスを持つexamples/配下のHTMLサンプル、examples/screenshots/配下の対応する参照画像。

## バッチ種別

E2Eテスト / ビジュアルリグレッションテスト / WebGPU特化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行） |
| 実行時刻 | 不定 |
| 実行曜日 | 不定 |
| 実行日 | 不定 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js 24以上がインストールされていること |
| 依存パッケージ | `npm ci`による依存関係のインストール完了 |
| ビルド完了 | `npm run build-module`によるthree.jsビルドファイルの生成完了 |
| 参照スクリーンショット | examples/screenshots/にwebgpu_*の参照画像が存在すること |

### 実行可否判定

- build/ディレクトリにthree.webgpu.jsが存在すること
- examples/ディレクトリに`webgpu_*.html`ファイルが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --make | フラグ | No | false | スクリーンショット生成モードで実行（--webgpuと組み合わせ可能） |
| [examples] | 文字列リスト | No | 全webgpu examples | 特定のexampleのみをテスト対象とする |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| examples/webgpu_*.html | HTMLファイル | テスト対象のWebGPUサンプルページ |
| examples/screenshots/webgpu_*.jpg | JPEGファイル | 参照スクリーンショット画像 |
| build/three.webgpu.js | JavaScriptファイル | ビルド済みWebGPU版three.jsライブラリ |
| test/e2e/deterministic-injection.js | JavaScriptファイル | 決定論的テスト用のスクリプト |
| test/e2e/clean-page.js | JavaScriptファイル | ページクリーンアップ用スクリプト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| test/e2e/output-screenshots/ | ディレクトリ | 差分画像の出力先 |
| stdout | テキスト | テスト結果のコンソール出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | webgpu_{example名}-actual.jpg, webgpu_{example名}-expected.jpg, webgpu_{example名}-diff.jpg |
| 出力先 | test/e2e/output-screenshots/ |
| 文字コード | バイナリ（JPEG） |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. サーバー起動
   └─ utils/server.jsを使用してポート1234でHTTPサーバーを起動

2. ブラウザ起動
   └─ Puppeteerでヘッドレスブラウザを起動（SwiftShaderを使用）

3. exampleファイル一覧取得
   └─ examples/ディレクトリからHTMLファイルを列挙

4. WebGPUフィルタリング
   └─ 'webgpu_'を含むファイルのみに絞り込み、例外リストを除外

5. 各exampleに対するテスト実行
   └─ ページ読み込み → レンダリング待機 → スクリーンショット撮影 → 比較

6. 結果出力
   └─ 成功/失敗のサマリーをコンソール出力

7. クリーンアップ
   └─ ブラウザとサーバーを終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[HTTPサーバー起動]
    B --> C[Puppeteerブラウザ起動]
    C --> D[examplesファイル一覧取得]
    D --> E[webgpu_プレフィックスでフィルタリング]
    E --> F[例外リストを除外]
    F --> G[各exampleをループ]
    G --> H[ページ読み込み]
    H --> I[決定論的スクリプト注入]
    I --> J[レンダリング待機]
    J --> K[スクリーンショット撮影]
    K --> L{参照画像存在?}
    L -->|Yes| M[ピクセル比較]
    L -->|No| N[エラー記録]
    M --> O{差分 < 0.3%?}
    O -->|Yes| P[成功ログ出力]
    O -->|No| Q[差分画像保存]
    Q --> N
    P --> R{次のexample?}
    N --> R
    R -->|Yes| G
    R -->|No| S[結果サマリー出力]
    S --> T[ブラウザ・サーバー終了]
    T --> U[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ネットワークタイムアウト | ページ読み込みが5分を超過 | 例外リストに追加、または処理をスキップ |
| - | レンダータイムアウト | レンダリングが5秒を超過 | 例外リストに追加検討 |
| - | 参照画像なし | screenshots/に対応画像がない | make-screenshotで生成 |
| - | 差分超過 | ピクセル差分が0.3%を超過 | コード確認または参照画像再生成 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 2回（numAttempts = 2） |
| リトライ間隔 | 即時 |
| リトライ対象エラー | 全エラー |

### 障害時対応

1. 失敗したexample一覧がコンソールに出力される
2. `npm run make-screenshot --webgpu [失敗したexample名]`で参照画像を再生成
3. WebGPUが必要なexampleは例外リストに含まれている場合がある

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約50-100 webgpu examples |
| 目標処理時間 | 10分以内 |
| メモリ使用量上限 | ブラウザ依存 |

## 排他制御

- 同一環境での同時実行は非推奨（ポート競合の可能性）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | サーバー起動時 | （暗黙的） |
| 進捗ログ | 各example処理完了時 | "Diff X.X% in file: webgpu_{example名}" |
| 終了ログ | バッチ終了時 | "TEST PASSED! X screenshots rendered correctly." |
| エラーログ | 差分超過時 | "Diff wrong in X.X% of pixels in file: webgpu_{example名}" |
| 警告ログ | 処理継続可能な問題発生時 | 黄色でコンソール出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 失敗example数 | 1件以上 | コンソール出力 |

## 備考

- test-e2eと同じ処理ロジックを使用するが、--webgpuフラグにより対象をフィルタリング
- WebGPU関連の多くのexampleは例外リストに含まれている（WebGPU APIが必要なため）
- WebGPUを実際に使用するexamplesはSwiftShaderでは動作しないものがある
- 主に開発者がWebGPU関連の変更を確認する際にローカルで使用
